﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;



namespace csRT1000
{
    //==============================================================================
    //ERROR CODE
    //函数返回错误码
    enum RETURN_ERRER_CODE
    {
	    RETURN_SUCCESS = 0,

	    ERROR_OFFSET = 10000, //错误码偏移量

	    ERROR_SPEEDDIR = (ERROR_OFFSET+5), //变速时输入速度为负

	    ERROR_RUNNING = (ERROR_OFFSET + 8),//运动运行错误

	    ERROR_PLSOUTMODE = (ERROR_OFFSET + 9),//脉冲输出模式有误

	    ERROR_CARDNUM = (ERROR_OFFSET + 10), //1000卡的卡号计算大于最大卡数错误

	    ERROR_OTHER = (ERROR_OFFSET + 11), //其他错误

	    ERROR_CARDNOFIND = (ERROR_OFFSET + 12),//未找到卡错误
	
	    ERROR_PARAMETER = (ERROR_OFFSET + 13), //函数传参错误

	    ERROR_CARDTYPE = (ERROR_OFFSET + 14),//卡的类型参数错误,目前只能是0为4轴1为12轴

	    ERROR_INVALID_HANDLE_VALUE = (ERROR_OFFSET + 15),//设备驱动句柄无效错误

	    ERROR_WINDRV_VERSION = (ERROR_OFFSET + 16),//WinDriver驱动版本不对应错误

	    ERROR_WD_FUNCTION = (ERROR_OFFSET + 17),//WinDriver底层函数执行失败

	    ERROR_SHAREMEN_AND_MUTEX = (ERROR_OFFSET + 18),//共享内存错误和互斥量错误

	    ERROR_OPEN_CARD = (ERROR_OFFSET + 19),//驱动开卡失败错误

	    ERROR_ADDRMEN_INIT = (ERROR_OFFSET + 20), //地址空间没有初始化时调用PCI通信函数错误

        ERROR_MOVE_POSITION = (ERROR_OFFSET + 21), //点位运动时实际运动距离大于2^24 错误
    };
    //==============================================================================

    class RT1000
    {
        [DllImport("RT1000.dll", EntryPoint = "Rt1000BoardInit", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000BoardInit();
        [DllImport("RT1000.dll", EntryPoint = "Rt1000BoardClose", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000BoardClose();

        /*
        #define PLSMODE_PULDIR_UPEDGE				0   //pulse/dir模式，脉冲上升沿有效
        #define PLSMODE_PULDIR_DOWNEDGE         	1   //pulse/dir模式，脉冲下降沿有效
        #define PLSMODE_CWCCW_UPEDGE				2   //CW/CCW模式，脉冲上升沿有效
        #define PLSMODE_CWCCW_DOWNEDGE        		3   //CW/CCW模式，脉冲下降沿有效
        */
        [DllImport("RT1000.dll", EntryPoint = "Rt1000SetPlsOutmode", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000SetPlsOutmode(short Axis, short PlsOutmode);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000GetSpeed", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000GetSpeed(short Axis);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000ChangeSpeed", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000ChangeSpeed(short Axis, int NewVel);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000DecelStop", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000DecelStop(short Axis);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000ImmediateStop", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000ImmediateStop(short Axis);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartTMove", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartTMove(short Axis, int Dist, int StrVel, int MaxVel, double Tacc);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartTaMove", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartTaMove(short Axis, int Pos, double StrVel, double MaxVel, double Tacc);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartSMove", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartSMove(short Axis, int Dist, int StrVel, int MaxVel, double Tacc);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartSaMove", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartSaMove(short Axis, int Pos, int StrVel, int MaxVel, double Tacc);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartTvMove", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartTvMove(short Axis, int StrVel, int MaxVel, double Tacc);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartSvMove", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartSvMove(short Axis, int StrVel, int MaxVel, double Tacc);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartTLine", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartTLine(short TotalAxis, short[] AxisArray, int[] DistArray, int StrVel, int MaxVel, double Tacc);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000StartTaLine", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000StartTaLine(short TotalAxis,  short[] AxisArray,  int[] DistArray, int StrVel, int MaxVel, double Tacc);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000HomeMove", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000HomeMove(short Axis, int StrVel, int MaxVel, double Tacc);

        /*
        返回值: 0：正在运行
	            1:脉冲输出完毕停止
                2:指令停止
	            3:遇限位停止
	            4:遇原点停止
        */
        [DllImport("RT1000.dll", EntryPoint = "Rt1000CheckDone", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000CheckDone(short Axis);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000GetCommandPos", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000GetCommandPos(short Axis);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000SetCommandPos", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000SetCommandPos(short Axis, double Pos);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000OutBit", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000OutBit(short BitNo, short BitData);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000InBit", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000InBit(short BitNo);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000GetOutbit", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000GetOutbit(short BitNo);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000SetSd", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000SetSd(short Axis, short SdMode);
        [DllImport("RT1000.dll", EntryPoint = "Rt1000GetAxisStatus", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000GetAxisStatus(short Axis);

        [DllImport("RT1000.dll", EntryPoint = "Rt1000SetAxisAlm_Level", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000SetAxisAlm_Level(short Cardno, short AxisNum, short AlmLogic);
        [DllImport("RT1000.dll", EntryPoint = " Rt1000GetAxisAlm_Level", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern int Rt1000GetAxisAlm_Level(short Cardno, short AxisNum, out short AlmLogic);


    }
}
