//==============================================================================
//
// Title:		RT1000
// Purpose:		A short description of the interface.
//
// Created on:	2020/11/24 at 14:42:07 by .
// Copyright:	. All Rights Reserved.
//
//==============================================================================

#ifndef __RT1000_H__
#define __RT1000_H__

#ifdef __cplusplus
    extern "C" {
#endif

//==============================================================================
// Include files
//==============================================================================
// Constants
//#define RT1000_API __declspec(dllexport)
#define RT1000_API 
#define WINAPI __stdcall
//==============================================================================
// Types
typedef unsigned long       DWORD;
typedef signed   int        int32;


//==============================================================================
//ERROR CODE
//ش
enum RETURN_ERRER_CODE
{
	RETURN_SUCCESS = 0,

	ERROR_OFFSET = 10000, //ƫ

	ERROR_SPEEDDIR = (ERROR_OFFSET+5), //ʱٶΪ

	ERROR_RUNNING = (ERROR_OFFSET + 8),//˶д

	ERROR_PLSOUTMODE = (ERROR_OFFSET + 9),//ģʽ

	ERROR_CARDNUM = (ERROR_OFFSET + 10), //1000Ŀż

	ERROR_OTHER = (ERROR_OFFSET + 11), //

	ERROR_CARDNOFIND = (ERROR_OFFSET + 12),//δҵ
	
	ERROR_PARAMETER = (ERROR_OFFSET + 13), //δ

	ERROR_CARDTYPE = (ERROR_OFFSET + 14),//Ͳ,Ŀǰֻ0Ϊ41Ϊ12

	ERROR_INVALID_HANDLE_VALUE = (ERROR_OFFSET + 15),//豸Ч

	ERROR_WINDRV_VERSION = (ERROR_OFFSET + 16),//WinDriver汾Ӧ

	ERROR_WD_FUNCTION = (ERROR_OFFSET + 17),//WinDriverײ㺯ִʧ

	ERROR_SHAREMEN_AND_MUTEX = (ERROR_OFFSET + 18),//ڴͻ

	ERROR_OPEN_CARD = (ERROR_OFFSET + 19),//ʧܴ

	ERROR_ADDRMEN_INIT = (ERROR_OFFSET + 20), //ַռûгʼʱPCIͨź

    ERROR_MOVE_POSITION = (ERROR_OFFSET + 21), //λ˶ʱʵ˶2^24 
};

//==============================================================================
// Global functions
//----------------ƿĳʼ͹رպ-----------------
RT1000_API DWORD WINAPI Rt1000BoardInit(void);
RT1000_API DWORD WINAPI Rt1000BoardClose(void);

//----------------ģʽ-------------------------
#define PLSMODE_PULDIR_UPEDGE				0   //pulse/dirģʽЧ
#define PLSMODE_PULDIR_DOWNEDGE         	1   //pulse/dirģʽ½Ч
#define PLSMODE_CWCCW_UPEDGE				2   //CW/CCWģʽЧ
#define PLSMODE_CWCCW_DOWNEDGE        		3   //CW/CCWģʽ½Ч
RT1000_API DWORD WINAPI Rt1000SetPlsOutmode(short Axis,short PulseMode);

//----------------˶---------------------------------
RT1000_API DWORD WINAPI Rt1000StartTvMove(short Axis,long StrVel,long MaxVel,double Tacc);
RT1000_API DWORD WINAPI Rt1000StartSvMove(short Axis,long StrVel,long MaxVel,double Tacc);

//---------------ٶȲ------------------------------
RT1000_API DWORD WINAPI Rt1000GetSpeed(short Axis);
RT1000_API DWORD WINAPI Rt1000ChangeSpeed(short Axis,long NewVel);

//---------------ֹͣͼͣ----------------------------
RT1000_API DWORD WINAPI Rt1000DecelStop(short Axis);
RT1000_API DWORD WINAPI Rt1000ImmediateStop(short Axis);

//---------------Tߵĵλ˶λú;λ-----
RT1000_API DWORD WINAPI Rt1000StartTMove(short Axis,long Dist, long StrVel,long MaxVel,double Tacc);
RT1000_API DWORD WINAPI Rt1000StartTaMove(short Axis,long Pos, double StrVel, double MaxVel,double Tacc);

//---------------Sߵĵλ˶λú;λ-----
RT1000_API DWORD WINAPI Rt1000StartSMove(short Axis,long Dist, long StrVel,long MaxVel,double Tacc);
RT1000_API DWORD WINAPI Rt1000StartSaMove(short Axis,long Pos, long StrVel,long MaxVel,double Tacc);

//---------------ֱ߲岹λú;λ--------------
RT1000_API DWORD WINAPI Rt1000StartTLine(short TotalAxis,short *AxisArray,long *DistArray,long StrVel, long MaxVel, double Tacc);
RT1000_API DWORD WINAPI Rt1000StartTaLine(short TotalAxis,short *AxisArray,long *PosArray,long StrVel, long MaxVel, double Tacc);

//---------------ԭ˶--------------------------------
RT1000_API DWORD WINAPI Rt1000HomeMove(short Axis,long StrVel,long MaxVel,double Tacc);

//---------------˶״̬⺯--------------------------
/*
ֵ: 0
	   1:ֹͣ
       2:ָֹͣ
	   3:λֹͣ
	   4:ԭֹͣ
*/
RT1000_API DWORD WINAPI Rt1000CheckDone(short Axis);

//---------------ȡ----------------------
RT1000_API int32 WINAPI Rt1000GetCommandPos(short Axis);
RT1000_API DWORD WINAPI Rt1000SetCommandPos(short Axis,double Pos);

//---------------ͨI/O-------------------------------
RT1000_API DWORD WINAPI Rt1000OutBit(short OUTn,short BitData);
RT1000_API DWORD WINAPI Rt1000InBit(short INn);
RT1000_API DWORD WINAPI Rt1000GetOutbit(short BitNo);

//---------------רI/O-------------------------------
RT1000_API DWORD WINAPI Rt1000SetSd(short Axis ,short SdMode);
RT1000_API DWORD WINAPI Rt1000GetAxisStatus(short Axis);


RT1000_API DWORD WINAPI Rt1000StartTarc(short *AxisArray,long OffsetC1,long OffsetC2,double Angle,long StrVel,long MaxVel,double Tacc);

RT1000_API DWORD WINAPI Rt1000SetAxisAlm_Level(short Cardno, short AxisNum, short AlmLogic);
RT1000_API DWORD WINAPI Rt1000GetAxisAlm_Level(short Cardno, short AxisNum, DWORD* AlmLogic);
//-------------------------------------------------------------------
//ͻ
RT1000_API DWORD WINAPI Rt1000SetPWMEn(short Cardno,short value);
RT1000_API DWORD WINAPI Rt1000SetHardLimitEn(short Cardno,short Axis,short enable);
RT1000_API DWORD WINAPI Rt1000GetPWMEn(short Cardno,DWORD* Value);
//RT1000_API DWORD WINAPI Rt1000SelectIOCounter(short Cardno,short IONo);
RT1000_API DWORD WINAPI Rt1000SetPWMCount(short Cardno,DWORD Value);
RT1000_API DWORD WINAPI Rt1000GetPWMCount(short Cardno,DWORD * Value);
RT1000_API DWORD WINAPI Rt1000GetCount(short Cardno,DWORD* Value);
RT1000_API DWORD WINAPI Rt1000CleanCount(short Cardno);
RT1000_API DWORD WINAPI Rt1000SetCounterMode(short Cardno,short Mode);
RT1000_API DWORD WINAPI Rt1000SetStopEn(short Cardno,short Stopno);
RT1000_API DWORD WINAPI Rt1000GetStopEn(short Cardno,DWORD* Value);
RT1000_API DWORD WINAPI Rt1000GetProbePosition(short Cardno,short RegNo,DWORD* Value);
RT1000_API DWORD WINAPI Rt1000CleanProbePosition(short Cardno,short RegNo);
RT1000_API DWORD WINAPI Rt1000SetSoftLimitEnable(short Cardno,short OnorOff,short AxisNum);
RT1000_API DWORD WINAPI Rt1000SetGetLimitValue(short Cardno,short AxisNum,short ReadWriteTag,short PorNTag,DWORD* Value);

//---------------------------------------------------------------------
//---------------------------------------------------------------------

#ifdef __cplusplus
    }
#endif

#endif  /* ndef __RT1000_H__ */
